/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import LumiSoft.UI.Controls.Utils;
import LumiSoft.UI.Controls.ViewStyle;
import LumiSoft.UI.Controls.WEditBox_base;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class WTextEdit
extends JPanel
implements FocusListener,
MouseListener,
MouseMotionListener {
    private boolean m_UseStaticViewStyle = true;
    private ViewStyle m_ViewStyle = null;
    private WEditBox_base m_pTextbox = null;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;
    private String m_HittedObject = "";
    private Dimension m_Size = new Dimension(0, 0);

    public WTextEdit() {
        this.m_ViewStyle = new ViewStyle();
        this.m_pTextbox = new WEditBox_base();
        this.m_pTextbox.setBorder(null);
        this.m_pTextbox.setEditType(2);
        this.m_pTextbox.addFocusListener(this);
        this.m_pTextbox.addMouseListener(this);
        this.m_pTextbox.addMouseMotionListener(this);
        this.add(this.m_pTextbox);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        if (this.m_Size != this.getSize()) {
            this.m_Size = this.getSize();
            this.SizeChanged();
        }
        Rectangle clientRect = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        boolean hot = Utils.ContainsFocus(this) || clientRect.contains(this.m_MousePos);
        this.Draw((Graphics2D)g, hot);
    }

    private void Draw(Graphics2D g, boolean hot) {
        Rectangle clientRect = new Rectangle(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        g.setColor(this.m_ViewStyle.GetBorderColor(hot));
        g.draw(clientRect);
    }

    protected void SizeChanged() {
        this.m_pTextbox.setBounds(new Rectangle(1, 1, this.getWidth() - 2, this.getHeight() - 2));
    }

    public void focusGained(FocusEvent e) {
        this.m_pTextbox.selectAll();
        this.m_pTextbox.setBackground(this.m_ViewStyle.GetEditColor(this.getReadOnly(), true, true));
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.m_pTextbox.setBackground(this.m_ViewStyle.GetEditColor(this.getReadOnly(), true, false));
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.m_MouseModifiers = 0;
        this.isEnabled();
    }

    public void mouseEntered(MouseEvent e) {
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public String getText() {
        return this.m_pTextbox.getText();
    }

    public void setText(String value) {
        this.m_pTextbox.setText(value);
    }

    public String getPasswordChar() {
        return this.m_pTextbox.getText();
    }

    public void setPasswordChar(String value) {
        this.m_pTextbox.setText(value);
    }

    public int getTextAlign() {
        return this.m_pTextbox.getTextAlign();
    }

    public void setTextAlign(int value) {
        this.m_pTextbox.setTextAlign(value);
    }

    public boolean getReadOnly() {
        return this.m_pTextbox.getReadOnly();
    }

    public void setReadOnly(boolean value) {
        this.m_pTextbox.setReadOnly(value);
        this.m_pTextbox.setBackground(this.m_ViewStyle.GetEditColor(value, this.isEnabled(), false));
    }

    public int getSelectionStart() {
        return this.m_pTextbox.getSelectionStart();
    }

    public void setSelectionStart(int value) {
        this.m_pTextbox.setSelectionStart(value);
    }

    public int getSelectionEnd() {
        return this.m_pTextbox.getSelectionEnd();
    }

    public void setSelectionEnd(int value) {
        this.m_pTextbox.setSelectionEnd(value);
    }
}

