/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.Utils;
import LumiSoft.UI.Controls.ViewStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class WSpinEdit
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected boolean m_UseStaticViewStyle = true;
    protected ViewStyle m_ViewStyle = null;
    private int m_SpinnersAlign = 3;
    private boolean m_SpinnersVisible = true;
    private int m_ButtonWidth = 14;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;
    private String m_HittedObject = "";
    private Dimension m_Size = new Dimension(0, 0);

    public WSpinEdit() {
        this.m_ViewStyle = new ViewStyle();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        if (this.m_Size != this.getSize()) {
            this.m_Size = this.getSize();
            this.SizeChanged();
        }
        this.Draw((Graphics2D)g);
    }

    protected void SizeChanged() {
    }

    private Rectangle getTriangleRect(Rectangle buttonRect) {
        return new Rectangle(buttonRect.x + 3, buttonRect.y + 3, buttonRect.width - 5, buttonRect.height - 5);
    }

    private void Draw(Graphics2D g) {
        Rectangle clientRect = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        boolean hot = Utils.ContainsFocus(this) || clientRect.contains(this.m_MousePos);
        g.setColor(this.m_ViewStyle.getButtonColor());
        g.fill(clientRect);
        if (this.getSpinnersVisible()) {
            boolean upHot = this.getUpButtonRect().contains(this.m_MousePos);
            boolean downHot = this.getDownButtonRect().contains(this.m_MousePos);
            g.setColor(this.m_ViewStyle.GetButtonColor(upHot, this.m_MouseModifiers == 1024));
            g.fill(this.getUpButtonRect());
            g.setColor(Color.BLACK);
            Paint.DrawTriangle(g, this.getTriangleRect(this.getUpButtonRect()), 1);
            g.setColor(this.m_ViewStyle.GetButtonColor(downHot, this.m_MouseModifiers == 1024));
            g.fill(this.getDownButtonRect());
            g.setColor(Color.BLACK);
            Paint.DrawTriangle(g, this.getTriangleRect(this.getDownButtonRect()), 2);
        }
        g.setColor(this.m_ViewStyle.GetBorderColor(hot));
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.drawLine(this.getButtonsRect().x, 0, this.getButtonsRect().x, this.getHeight());
        g.drawLine((int)this.getButtonsRect().getMaxX(), 0, (int)this.getButtonsRect().getMaxX(), this.getHeight());
        g.drawLine(this.getButtonsRect().x, this.getHeight() / 2, (int)this.getButtonsRect().getMaxX(), this.getHeight() / 2);
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseModifiers = e.getModifiersEx();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.m_MouseModifiers = 0;
        if (this.getUpButtonRect().contains(this.m_MousePos)) {
            this.OnUpButtonClicked();
        } else if (this.getDownButtonRect().contains(this.m_MousePos)) {
            this.OnDownButtonClicked();
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
        String hittedObject = "";
        if (this.getUpButtonRect().contains(this.m_MousePos)) {
            hittedObject = "upButtons";
        } else if (this.getDownButtonRect().contains(this.m_MousePos)) {
            hittedObject = "downButtons";
        }
        if (this.m_HittedObject != hittedObject) {
            this.m_HittedObject = hittedObject;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    private Rectangle getButtonsRect() {
        if (this.getSpinnersVisible()) {
            if (this.m_SpinnersAlign == 3) {
                return new Rectangle(this.getWidth() - this.m_ButtonWidth, 1, this.m_ButtonWidth - 1, this.getHeight() - 2);
            }
            return new Rectangle(0, 0, this.m_ButtonWidth - 1, this.getHeight() - 2);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private Rectangle getUpButtonRect() {
        Rectangle rectButton = this.getButtonsRect();
        Rectangle retVal = new Rectangle(rectButton.x, rectButton.y, rectButton.width, rectButton.height / 2);
        return retVal;
    }

    private Rectangle getDownButtonRect() {
        Rectangle rectButton = this.getButtonsRect();
        Rectangle retVal = new Rectangle(rectButton.x, rectButton.height / 2 + 1, rectButton.width, rectButton.height / 2);
        return retVal;
    }

    protected Rectangle getEditRect() {
        if (this.m_SpinnersAlign == 3) {
            return new Rectangle(2, 1, this.getWidth() - this.getButtonsRect().width - 4, this.getHeight() - 2);
        }
        return new Rectangle((int)this.getButtonsRect().getMaxX() + 2, 1, this.getWidth() - this.getButtonsRect().width - 4, this.getHeight() - 2);
    }

    public boolean getSpinnersVisible() {
        return this.m_SpinnersVisible;
    }

    public void setSpinnersVisible(boolean value) {
        if (this.m_SpinnersVisible != value) {
            this.m_SpinnersVisible = value;
            this.repaint();
        }
    }

    public int getSpinnersAlign() {
        return this.m_SpinnersAlign;
    }

    public void setSpinnersAlign(int value) {
        if (this.m_SpinnersAlign != value) {
            this.m_SpinnersAlign = value;
            this.repaint();
        }
    }

    protected void OnUpButtonClicked() {
    }

    protected void OnDownButtonClicked() {
    }
}

