/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import LumiSoft.UI.Controls.WButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class WFrame
extends JPanel
implements HierarchyBoundsListener {
    private JSplitPane m_pSplitter = null;
    private JPanel m_pContolPane = null;
    private JPanel m_pFormPane = null;
    private JPanel m_pToolbarPane = null;
    private Component m_pPaneControl = null;
    private Component m_pPaneToolbar = null;
    private Component m_pPaneForm = null;
    private WButton m_pToggleBtn = null;
    private int m_ControlPaneWidth = 160;

    public WFrame() {
        this.setSize(200, 400);
        this.m_pContolPane = new JPanel();
        this.m_pContolPane.setLayout(new BorderLayout());
        this.m_pContolPane.setLocation(0, 25);
        this.m_pFormPane = new JPanel();
        this.m_pFormPane.setLayout(new BorderLayout());
        this.m_pFormPane.setLocation(0, 25);
        this.m_pToolbarPane = new JPanel();
        this.m_pToolbarPane.setLayout(new BorderLayout());
        this.m_pToolbarPane.setLocation(0, 0);
        this.m_pToggleBtn = new WButton();
        this.m_pToggleBtn.setText("<<");
        this.m_pToggleBtn.setSize(30, 16);
        this.m_pToggleBtn.addClickedListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WFrame.this.OnToggleButtonPressed();
            }
        });
        this.m_pSplitter = new JSplitPane(1, this.m_pContolPane, this.m_pFormPane);
        this.m_pSplitter.setLocation(0, 25);
        this.add(this.m_pToolbarPane);
        this.add(this.m_pSplitter);
        this.add(this.m_pToggleBtn);
        this.addHierarchyBoundsListener(this);
        this.setLayout(null);
        this.ShowBar();
    }

    private void OnToggleButtonPressed() {
        if (this.m_pToggleBtn.getText() == "<<") {
            this.HideBar();
        } else {
            this.ShowBar();
        }
    }

    public void ancestorResized(HierarchyEvent e) {
        this.Layout();
    }

    public void ancestorMoved(HierarchyEvent e) {
    }

    private void Layout() {
        if (this.m_pSplitter.getDividerSize() > 0) {
            this.m_pToggleBtn.setLocation(this.m_pSplitter.getDividerLocation() - this.m_pToggleBtn.getWidth(), 5);
            this.m_pToolbarPane.setLocation(this.m_pSplitter.getDividerLocation() + this.m_pSplitter.getDividerSize(), 0);
            this.m_pToolbarPane.setSize(this.getWidth() - this.m_pSplitter.getDividerLocation(), 22);
            this.m_pToolbarPane.setBackground(Color.BLUE);
            this.m_ControlPaneWidth = this.m_pSplitter.getDividerLocation();
        } else {
            this.m_pToggleBtn.setLocation(5, 5);
            this.m_pToolbarPane.setLocation((int)this.m_pToggleBtn.getBounds().getMaxX() + 10, 0);
            this.m_pToolbarPane.setSize(this.getWidth() - this.m_pToolbarPane.getBounds().x, 25);
        }
        this.m_pSplitter.setSize(this.getWidth(), this.getHeight() - 25);
    }

    public void ShowBar() {
        this.m_pToggleBtn.setText("<<");
        this.m_pSplitter.setDividerSize(6);
        this.m_pSplitter.setDividerLocation(this.m_ControlPaneWidth);
        this.Layout();
    }

    public void HideBar() {
        int x = (int)this.m_pToggleBtn.getBounds().getMaxX();
        if (this.m_pSplitter.getDividerSize() > 0) {
            this.m_pToggleBtn.setText(">>");
            this.m_pSplitter.setDividerSize(0);
            this.m_pSplitter.setDividerLocation(0);
            this.Layout();
        }
    }

    public boolean getSplitterLocked() {
        return this.m_pSplitter.isEnabled();
    }

    public void setSplitterLocked(boolean value) {
        this.m_pSplitter.setEnabled(value);
    }

    public int getSplitterWidth() {
        return this.m_pSplitter.getDividerSize();
    }

    public void setSplitterWidth(int value) {
        this.m_pSplitter.setDividerSize(value);
    }

    public void setToolBar(Component value) {
        if (this.m_pPaneToolbar != null) {
            this.m_pToolbarPane.remove(this.m_pPaneToolbar);
            this.m_pPaneToolbar.setVisible(false);
        }
        this.m_pPaneToolbar = value;
        this.m_pPaneToolbar.setLocation(0, 0);
        this.m_pToolbarPane.add(value, "Center");
    }

    public void setForm(Component value) {
        if (this.m_pPaneForm != null) {
            this.remove(this.m_pPaneForm);
            this.m_pPaneForm.setVisible(false);
        }
        this.m_pPaneForm = value;
        this.m_pPaneForm.setLocation(0, 0);
        this.m_pFormPane.add(value, "Center");
    }

    public void setControl(Component value) {
        if (this.m_pPaneControl != null) {
            this.remove(this.m_pPaneControl);
            this.m_pPaneControl.removeHierarchyBoundsListener(this);
        }
        this.m_pPaneControl = value;
        this.m_pPaneControl.setLocation(0, 0);
        this.m_pContolPane.add(value, "Center");
        this.m_pPaneControl.addHierarchyBoundsListener(this);
    }
}

