/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WComboBox;

import LumiSoft.UI.Controls.WComboBox.WComboBox;
import LumiSoft.UI.Controls.WComboBox.WComboItem;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class WComboPopUp
extends JPopupMenu
implements MouseListener,
MouseMotionListener,
KeyListener,
PopupMenuListener {
    private WComboBox m_pWComboBox = null;
    private JList m_pList = null;
    private DefaultListModel m_pItems = null;

    public WComboPopUp(WComboBox combo) {
        this.m_pWComboBox = combo;
        combo.addKeyListener(this);
        this.m_pList = new JList();
        this.m_pItems = new DefaultListModel();
        int i = 0;
        while (i < combo.getItems().size()) {
            WComboItem item = (WComboItem)combo.getItems().get(i);
            this.m_pItems.addElement(item);
            ++i;
        }
        this.m_pList.addMouseListener(this);
        this.m_pList.addMouseMotionListener(this);
        this.m_pList.setModel(this.m_pItems);
        this.m_pList.setFont(combo.getFont());
        this.m_pList.setFocusable(false);
        if (this.m_pItems.size() > combo.getMaxVisibleItems()) {
            this.m_pList.setVisibleRowCount(combo.getMaxVisibleItems());
        } else {
            this.m_pList.setVisibleRowCount(this.m_pItems.size());
        }
        JScrollPane listScrollPane = new JScrollPane(this.m_pList);
        listScrollPane.setBorder(null);
        if (this.m_pList.getPreferredScrollableViewportSize().width + 20 < combo.getWidth()) {
            this.setPopupSize(combo.getWidth(), this.m_pList.getPreferredScrollableViewportSize().height + 6);
        } else {
            this.setPopupSize(this.m_pList.getPreferredScrollableViewportSize().width + 20, this.m_pList.getPreferredScrollableViewportSize().height + 6);
        }
        this.add(listScrollPane);
        this.setFocusable(false);
        this.addPopupMenuListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int index = this.m_pList.locationToIndex(e.getPoint());
        if (index > -1) {
            this.m_pList.setSelectedIndex(index);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getModifiers() == 16) {
            if (this.m_pList.getSelectedValue() != null) {
                this.m_pWComboBox.OnPopupItemSelected((WComboItem)this.m_pList.getSelectedValue());
            }
            this.setVisible(false);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            if (this.m_pList.getSelectedIndex() - 1 > -1) {
                this.m_pList.setSelectedIndex(this.m_pList.getSelectedIndex() - 1);
            }
        } else if (e.getKeyCode() == 40) {
            if (this.m_pList.getSelectedIndex() + 1 < this.m_pItems.size()) {
                this.m_pList.setSelectedIndex(this.m_pList.getSelectedIndex() + 1);
            }
        } else if (e.getKeyCode() == 27) {
            this.setVisible(false);
        } else if (e.getKeyCode() == 10 && this.m_pList.getSelectedValue() != null) {
            this.m_pWComboBox.OnPopupItemSelected((WComboItem)this.m_pList.getSelectedValue());
            this.setVisible(false);
        }
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.m_pWComboBox.OnPopupClosed();
    }
}

