/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Control.WGrid;

import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.ViewStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class WScrollBar {
    private ViewStyle m_ViewStyle = null;
    private int m_Minimum = 0;
    private int m_Maximum = 1;
    private int m_Position = 0;
    private Rectangle m_pBounds = new Rectangle(-1, -1, 0, 0);
    private Component m_pParent = null;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;
    private String m_HittedObject = "";
    private boolean m_Vertical = true;

    public WScrollBar(Component parent, boolean vertical) {
        this.m_pParent = parent;
        this.m_Vertical = vertical;
        this.m_ViewStyle = new ViewStyle();
    }

    public void Paint(Graphics2D g) {
        if (this.m_pBounds.getHeight() < 1.0) {
            return;
        }
        int h = (int)this.m_pBounds.getHeight();
        g.setColor(ViewStyle.GetColorFromRgb(242, 242, 242));
        g.fill(this.m_pBounds);
        g.setColor(ViewStyle.GetColorFromRgb(212, 208, 200));
        g.drawRect(this.m_pBounds.x, this.m_pBounds.y, this.m_pBounds.width - 1, this.m_pBounds.height - 1);
        g.setColor(this.m_ViewStyle.GetButtonColor(this.getScrollPaneRect().contains(this.m_MousePos), this.m_MouseModifiers == 1024));
        g.fill(new Rectangle(this.GetScrollPaneX(), this.GetScrollPaneY(), this.GetScrollPaneWidth(), this.GetScrollPaneHeight()));
        g.setColor(this.m_ViewStyle.GetBorderColor(this.getScrollPaneRect().contains(this.m_MousePos)));
        g.draw(new Rectangle(this.GetScrollPaneX(), this.GetScrollPaneY(), this.GetScrollPaneWidth(), this.GetScrollPaneHeight()));
        g.setColor(this.m_ViewStyle.GetButtonColor(this.getDecreaseButtonRect().contains(this.m_MousePos), this.m_MouseModifiers == 1024));
        g.fill(this.getDecreaseButtonRect());
        g.setColor(Color.BLACK);
        if (this.m_Vertical) {
            Paint.DrawTriangle(g, this.getTriangleRect(this.getDecreaseButtonRect()), 1);
        } else {
            Paint.DrawTriangle(g, this.getTriangleRect(this.getDecreaseButtonRect()), 3);
        }
        g.setColor(this.m_ViewStyle.GetBorderColor(this.getDecreaseButtonRect().contains(this.m_MousePos)));
        g.draw(this.getDecreaseButtonRect());
        g.setColor(this.m_ViewStyle.GetButtonColor(this.getIncreaseButtonRect().contains(this.m_MousePos), this.m_MouseModifiers == 1024));
        g.fill(this.getIncreaseButtonRect());
        g.setColor(Color.BLACK);
        if (this.m_Vertical) {
            Paint.DrawTriangle(g, this.getTriangleRect(this.getIncreaseButtonRect()), 2);
        } else {
            Paint.DrawTriangle(g, this.getTriangleRect(this.getIncreaseButtonRect()), 4);
        }
        g.setColor(this.m_ViewStyle.GetBorderColor(this.getIncreaseButtonRect().contains(this.m_MousePos)));
        g.draw(this.getIncreaseButtonRect());
    }

    private void Repaint() {
        this.Paint((Graphics2D)this.m_pParent.getGraphics());
    }

    private Rectangle getTriangleRect(Rectangle buttonRect) {
        if (this.m_Vertical) {
            return new Rectangle(buttonRect.x + 4, buttonRect.y + 7, buttonRect.width - 7, buttonRect.height - 12);
        }
        return new Rectangle(buttonRect.x + 7, buttonRect.y + 4, buttonRect.width - 12, buttonRect.height - 7);
    }

    private int GetScrollPaneX() {
        if (this.m_Vertical) {
            return this.getBounds().x;
        }
        int x = this.m_pBounds.x + 18;
        if (this.m_Position != 0) {
            x = this.m_Position < this.getMaximum() ? (x += (this.m_pBounds.width - 36 - this.GetScrollPaneWidth()) / this.getMaximum() * this.m_Position) : (int)this.m_pBounds.getMaxX() - 18 - this.GetScrollPaneWidth();
        }
        return x;
    }

    private int GetScrollPaneY() {
        if (!this.m_Vertical) {
            return this.getBounds().y;
        }
        int y = this.m_pBounds.y + 18;
        if (this.m_Position != 0) {
            y = this.m_Position < this.getMaximum() ? (y += (this.m_pBounds.height - 36 - this.GetScrollPaneHeight()) / this.getMaximum() * this.m_Position) : (int)this.m_pBounds.getMaxY() - 18 - this.GetScrollPaneHeight();
        }
        return y;
    }

    private int GetScrollPaneWidth() {
        if (this.m_Vertical) {
            return this.getBounds().width - 1;
        }
        int width = (this.m_pBounds.width - 34) / this.getMaximum();
        if (width < 12) {
            width = 12;
        }
        return width;
    }

    private int GetScrollPaneHeight() {
        if (!this.m_Vertical) {
            return this.getBounds().height;
        }
        int height = (this.m_pBounds.height - 34) / this.getMaximum();
        if (height < 12) {
            height = 12;
        }
        return height;
    }

    protected void Process_mouseExited(MouseEvent e) {
        this.m_MouseModifiers = 0;
        this.m_MousePos = new Point(-1, -1);
        this.m_HittedObject = "";
        this.Repaint();
    }

    protected void Process_mousePressed(MouseEvent e) {
        this.m_MouseModifiers = e.getModifiersEx();
        this.Repaint();
    }

    protected void Process_mouseReleased(MouseEvent e) {
        this.m_MouseModifiers = 0;
        this.Repaint();
    }

    protected void Process_mouseClicked(MouseEvent e) {
        if (this.getDecreaseButtonRect().contains(e.getPoint()) && this.m_Position > this.m_Minimum) {
            --this.m_Position;
        } else if (this.getIncreaseButtonRect().contains(e.getPoint()) && this.m_Position < this.m_Maximum) {
            ++this.m_Position;
        }
        this.Repaint();
    }

    protected void Process_mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
        String hittedObject = "";
        if (this.getDecreaseButtonRect().contains(e.getPoint())) {
            hittedObject = "DecreaseButton";
        } else if (this.getIncreaseButtonRect().contains(e.getPoint())) {
            hittedObject = "IncreaseButton";
        } else if (this.getScrollPaneRect().contains(e.getPoint())) {
            hittedObject = "ScrollPane";
        }
        if (!this.m_HittedObject.equals(hittedObject)) {
            this.m_HittedObject = hittedObject;
            this.Repaint();
        }
    }

    private Rectangle getScrollPaneRect() {
        return new Rectangle(this.GetScrollPaneX(), this.GetScrollPaneY(), this.GetScrollPaneWidth(), this.GetScrollPaneHeight());
    }

    private Rectangle getDecreaseButtonRect() {
        if (this.m_Vertical) {
            return new Rectangle(this.m_pBounds.x, this.m_pBounds.y, this.m_pBounds.width - 1, 17);
        }
        return new Rectangle(this.m_pBounds.x, this.m_pBounds.y, 17, 17);
    }

    private Rectangle getIncreaseButtonRect() {
        if (this.m_Vertical) {
            return new Rectangle(this.m_pBounds.x, (int)this.m_pBounds.getMaxY() - 18, this.m_pBounds.width - 1, 17);
        }
        return new Rectangle((int)this.m_pBounds.getMaxX() - 18, this.m_pBounds.y, 17, 17);
    }

    protected boolean IsMouseActive() {
        return this.m_MousePos.x > -1;
    }

    public int getMinimum() {
        return this.m_Minimum;
    }

    public void setMinimum(int value) {
        if (this.m_Minimum != value) {
            this.m_Minimum = value;
        }
    }

    public int getMaximum() {
        return this.m_Maximum;
    }

    public void setMaximum(int value) {
        if (this.m_Maximum != value) {
            this.m_Maximum = value;
        }
    }

    public int getPosition() {
        return this.m_Position;
    }

    public void setPosition(int value) {
        if (this.m_Position != value) {
            if (value < this.m_Minimum) {
                value = this.m_Minimum;
            }
            if (value > this.m_Maximum) {
                value = this.m_Maximum;
            }
            this.m_Position = value;
        }
    }

    public Rectangle getBounds() {
        return this.m_pBounds;
    }

    public void setBounds(Rectangle value) {
        if (this.m_pBounds != value) {
            this.m_pBounds = value;
        }
    }
}

