/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import LumiSoft.UI.Controls.ViewStyle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class WPictureBox
extends JPanel
implements MouseListener,
MouseMotionListener {
    private boolean m_UseStaticViewStyle = true;
    private ViewStyle m_ViewStyle = null;
    private Image m_pImage = null;
    private boolean m_Strech = true;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;

    public WPictureBox() {
        this.m_ViewStyle = new ViewStyle();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        Rectangle clientRect = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        boolean hot = this.hasFocus() || clientRect.contains(this.m_MousePos);
        this.DrawControl((Graphics2D)g, hot);
    }

    private void DrawControl(Graphics2D g, boolean hot) {
        g.setColor(ViewStyle.GetColorFromRgb(212, 208, 200));
        g.fill(new Rectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1));
        if (this.m_pImage != null) {
            if (this.m_Strech) {
                g.drawImage(this.m_pImage, 1, 1, this.getWidth() - 2, this.getHeight() - 2, this);
            } else {
                int x = 1;
                if (this.m_pImage.getWidth(this) < this.getWidth() - 2) {
                    x = (this.getWidth() - this.m_pImage.getWidth(this)) / 2;
                }
                int y = 1;
                if (this.m_pImage.getHeight(this) < this.getHeight() - 2) {
                    y = (this.getHeight() - this.m_pImage.getHeight(this)) / 2;
                }
                g.drawImage(this.m_pImage, x, y, this);
            }
        }
        g.setColor(this.m_ViewStyle.GetBorderColor(hot));
        g.draw(new Rectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1));
    }

    public void mouseReleased(MouseEvent e) {
        this.m_MouseModifiers = 0;
        this.isEnabled();
    }

    public void mouseEntered(MouseEvent e) {
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public Image getImage() {
        return this.m_pImage;
    }

    public void setImage(Image value) {
        if (this.m_pImage != value) {
            this.m_pImage = value;
            this.repaint();
        }
    }

    public boolean getStretch() {
        return this.m_Strech;
    }

    public void setStrech(boolean value) {
        if (this.m_Strech != value) {
            this.m_Strech = value;
            this.repaint();
        }
    }
}

