/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WOutlookBar;

import LumiSoft.UI.Controls.ImageList;
import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.ViewStyle;
import LumiSoft.UI.Controls.WOutlookBar.Bar;
import LumiSoft.UI.Controls.WOutlookBar.Bars;
import LumiSoft.UI.Controls.WOutlookBar.HitInfo;
import LumiSoft.UI.Controls.WOutlookBar.Item;
import LumiSoft.UI.Controls.WOutlookBar.OutlookBarListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class WOutlookBar
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private EventListenerList m_pListners = null;
    private ImageList m_ImageList = null;
    private ImageList m_ImageListSmall = null;
    private boolean m_UseStaticViewStyle = true;
    private ViewStyle m_ViewStyle = null;
    private int m_ActiveBarIndex = -1;
    private int m_DefaultTextSpacing = 3;
    private boolean m_AllowItemsStuck = true;
    private Bars m_pBars = null;
    private HitInfo m_LastHitInfo = null;
    private Item m_StuckenItem = null;
    private boolean m_BeginUpdate = false;
    private Rectangle m_ActiveBarClientRect;
    private Point m_MousePos = new Point(0, 0);
    private int m_MouseModifiers = 0;
    private boolean m_NeedCalcDrawInfo = true;
    private Dimension m_Size = new Dimension(0, 0);
    static /* synthetic */ Class class$0;

    public WOutlookBar() {
        this.m_pBars = new Bars(this);
        this.m_pListners = new EventListenerList();
        this.m_ViewStyle = new ViewStyle();
        this.m_Size = this.getSize();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setFont(new Font("SansSerif", 0, 12));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_BeginUpdate) {
            return;
        }
        if (this.m_NeedCalcDrawInfo || this.m_Size.height != this.getSize().height || this.m_Size.width != this.getSize().width) {
            this.CalculateBarInfo((Graphics2D)g);
            this.m_Size = this.getSize();
        }
        g.setColor(this.m_ViewStyle.getBarClientAreaColor());
        g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.getBars().size() > 0) {
            this.DrawBars((Graphics2D)g);
            this.DrawVisibleBarItems((Graphics2D)g);
            this.DrawScrollButtons((Graphics2D)g);
        }
    }

    private void DrawBars(Graphics2D g) {
        int i = 0;
        while (i < this.m_pBars.size()) {
            Bar bar = (Bar)this.m_pBars.get(i);
            if (g.getClip().getBounds().intersects(bar.getBarRect())) {
                this.DrawBar(g, bar, bar.getBarRect().contains(this.m_MousePos), this.m_MouseModifiers == 1024);
            }
            ++i;
        }
    }

    private void DrawBar(Graphics2D g, Bar bar, boolean hot, boolean pressed) {
        Rectangle barRect = bar.getBarRect();
        if (hot) {
            if (pressed) {
                g.setColor(this.m_ViewStyle.getBarPressedColor());
            } else {
                g.setColor(this.m_ViewStyle.getBarHotColor());
            }
            g.fillRect((int)barRect.getX(), (int)barRect.getY(), (int)barRect.getWidth(), (int)barRect.getHeight());
            g.setColor(this.m_ViewStyle.getBarHotBorderColor());
            g.drawRect((int)barRect.getX(), (int)barRect.getY(), (int)barRect.getWidth(), (int)barRect.getHeight());
        } else {
            g.setColor(this.m_ViewStyle.getBarColor());
            g.fillRect((int)barRect.getX(), (int)barRect.getY(), (int)barRect.getWidth(), (int)barRect.getHeight());
            g.setColor(this.m_ViewStyle.getBarBorderColor());
            g.drawRect((int)barRect.getX(), (int)barRect.getY(), (int)barRect.getWidth(), (int)barRect.getHeight());
        }
        if (hot) {
            g.setColor(this.m_ViewStyle.getBarHotTextColor());
        } else {
            g.setColor(this.m_ViewStyle.getBarTextColor());
        }
        Paint.DrawText(g, bar.getFont(), bar.getText(), bar.getBarRect(), bar.getTextAlign());
    }

    private void DrawVisibleBarItems(Graphics2D g) {
        Bar bar = this.getActiveBar();
        if (bar != null) {
            Shape clip = g.getClip();
            g.setClip(bar.getBarClientRect());
            int i = bar.getFirstVisibleIndex();
            while (i < bar.getItems().size()) {
                Item item = (Item)bar.getItems().get(i);
                if (this.IsItemVisible(item) && clip.getBounds().intersects(item.getBounds())) {
                    boolean hot = bar.getBarClientRect().contains(this.m_MousePos) && item.getBounds().contains(this.m_MousePos) && !this.getUpScrollBtnRect().contains(this.m_MousePos) && !this.getDownScrollBtnRect().contains(this.m_MousePos);
                    this.DrawItem(g, item, bar, hot, this.m_MouseModifiers == 1024);
                }
                ++i;
            }
            g.setClip(clip);
        }
    }

    private void DrawItem(Graphics2D g, Item item, Bar bar, boolean hot, boolean pressed) {
        int itemStyle = bar.getItemsStyleCurrent();
        if (hot || item.equals(this.m_StuckenItem)) {
            Rectangle iRect = item.getBounds();
            if (itemStyle == 2) {
                iRect = item.getImageRect();
            }
            if (!item.equals(this.m_StuckenItem)) {
                if (pressed) {
                    g.setColor(this.m_ViewStyle.getBarItemPressedColor());
                } else {
                    g.setColor(this.m_ViewStyle.getBarItemHotColor());
                }
                g.fillRect(iRect.x, iRect.y, iRect.width, iRect.height);
            } else {
                g.setColor(this.m_ViewStyle.getBarItemSelectedColor());
                g.fillRect(iRect.x, iRect.y, iRect.width, iRect.height);
            }
            g.setColor(this.m_ViewStyle.getBarItemBorderHotColor());
            g.drawRect(iRect.x, iRect.y, iRect.width, iRect.height);
        } else {
            g.setColor(this.m_ViewStyle.getBarClientAreaColor());
            g.fill(item.getBounds());
            g.draw(item.getBounds());
        }
        if (item.getImage() != null) {
            g.drawImage(item.getImage(), (int)item.getImageRect().getX(), (int)item.getImageRect().getY(), this);
        }
        if (item.equals(this.m_StuckenItem)) {
            g.setColor(this.m_ViewStyle.getBarItemSelectedTextColor());
        } else {
            g.setColor(this.m_ViewStyle.getBarItemTextColor());
        }
        Paint.DrawText(g, item.getBar().getItemsFont(), item.getText(), item.getTextRect(), bar.getItemsTextAlign());
    }

    private void DrawScrollButtons(Graphics2D g) {
        if (g.getClip().getBounds().contains(this.getUpScrollBtnRect().getLocation()) || g.getClip().getBounds().contains(this.getDownScrollBtnRect().getLocation())) {
            boolean hot;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.getIsUpScrollBtnVisible()) {
                Rectangle upRect = this.getUpScrollBtnRect();
                hot = upRect.contains(this.m_MousePos);
                g.setColor(this.m_ViewStyle.GetButtonColor(hot, this.m_MouseModifiers == 1024));
                g.fill(upRect);
                g.setColor(this.m_ViewStyle.GetBorderColor(hot));
                g.draw(upRect);
                g.setColor(Color.BLACK);
                g.fillPolygon(new int[]{(int)upRect.getX() + 4, (int)upRect.getX() + 4 + 4, (int)upRect.getX() + 7 + 4}, new int[]{(int)upRect.getY() + 9, (int)upRect.getY() - 4 + 9, (int)upRect.getY() + 9}, 3);
            }
            if (this.getIsDownScrollBtnVisible()) {
                Rectangle downRect = this.getDownScrollBtnRect();
                hot = downRect.contains(this.m_MousePos);
                g.setColor(this.m_ViewStyle.GetButtonColor(hot, this.m_MouseModifiers == 1024));
                g.fill(downRect);
                g.setColor(this.m_ViewStyle.GetBorderColor(hot));
                g.draw(downRect);
                g.setColor(Color.BLACK);
                g.fillPolygon(new int[]{(int)downRect.getX() + 4, (int)downRect.getX() + 4 + 4, (int)downRect.getX() + 7 + 4}, new int[]{(int)downRect.getY() + 6, (int)downRect.getY() + 4 + 6, (int)downRect.getY() + 6}, 3);
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    private void CalculateBarInfo(Graphics2D g) {
        int barTop = 1;
        int visibleBarClientHeight = (int)this.getBounds().getHeight() - this.CalculateBarsHeight(g) - 2 - 1;
        int i = 0;
        while (i < this.m_pBars.size()) {
            Bar bar = (Bar)this.getBars().get(i);
            bar.setBarClientRect(new Rectangle(0, 0, 0, 0));
            int barTextHeight = Paint.CalcTextHeight(g, bar.getFont(), bar.getText(), (int)this.getBounds().getWidth() - 3);
            int barHeight = barTextHeight + this.m_DefaultTextSpacing * 2;
            if (i < this.m_ActiveBarIndex + 1) {
                bar.setBarRect(new Rectangle(1, barTop, (int)this.getBounds().getWidth() - 3, barHeight));
                if (i == this.m_ActiveBarIndex) {
                    Item item;
                    Rectangle barClntRect = new Rectangle(1, (int)bar.getBarRect().getY() + (int)bar.getBarRect().getHeight(), this.getWidth() - 2, visibleBarClientHeight - 1);
                    bar.setBarClientRect(barClntRect);
                    this.m_ActiveBarClientRect = barClntRect;
                    int top = (int)bar.getBarRect().getY() + bar.getBarRect().height + 3;
                    int it = 0;
                    while (it < bar.getItems().size()) {
                        item = (Item)bar.getItems().get(it);
                        item.setBounds(new Rectangle(-1, -1, 0, 0));
                        ++it;
                    }
                    it = bar.getFirstVisibleIndex();
                    while (it < bar.getItems().size()) {
                        item = (Item)bar.getItems().get(it);
                        int itemWidth = this.getWidth() - 3;
                        int itemHeight = this.CalculateItemHeight(g, item);
                        item.setBounds(new Rectangle(1, top, itemWidth, itemHeight));
                        top += itemHeight + 1;
                        ++it;
                    }
                }
            } else {
                bar.setBarRect(new Rectangle(1, barTop + visibleBarClientHeight, this.getWidth() - 3, barHeight));
            }
            barTop += barHeight + 1;
            ++i;
        }
        this.m_NeedCalcDrawInfo = false;
    }

    private void DrawHittedObject(HitInfo hitInfo) {
        if (hitInfo == null) {
            return;
        }
        Rectangle rect = null;
        switch (hitInfo.getHittedObject()) {
            case 1: {
                rect = hitInfo.getHittedBar().getBarRect();
                break;
            }
            case 2: {
                rect = hitInfo.getHittedItem().getBounds();
                break;
            }
            case 3: {
                rect = this.getUpScrollBtnRect();
                break;
            }
            case 4: {
                rect = this.getDownScrollBtnRect();
                break;
            }
            default: {
                return;
            }
        }
        this.repaint(new Rectangle(rect.x, rect.y, rect.width + 1, rect.height + 1));
        if (rect.intersects(this.getUpScrollBtnRect())) {
            rect = this.getUpScrollBtnRect();
            this.repaint(new Rectangle(rect.x, rect.y, rect.width + 1, rect.height + 1));
        }
        if (rect.intersects(this.getDownScrollBtnRect())) {
            rect = this.getDownScrollBtnRect();
            this.repaint(new Rectangle(rect.x, rect.y, rect.width + 1, rect.height + 1));
        }
    }

    private int CalculateBarsHeight(Graphics2D g) {
        int retVal = 0;
        int i = 0;
        while (i < this.getBars().size()) {
            Bar bar = (Bar)this.getBars().get(i);
            int barTextHeight = Paint.CalcTextHeight(g, bar.getFont(), bar.getText(), (int)this.getBounds().getWidth() - 3);
            retVal += barTextHeight + this.m_DefaultTextSpacing * 2 + 1;
            ++i;
        }
        return --retVal;
    }

    private int CalculateItemHeight(Graphics2D g, Item item) {
        int retVal = 0;
        int height = 0;
        switch (item.getBar().getItemsStyleCurrent()) {
            case 4: {
                height = Paint.CalcTextHeight(g, item.getBar().getItemsFont(), item.getText(), (int)this.getBounds().getWidth() - 16 - 7);
                retVal = height + 8;
                break;
            }
            default: {
                height = Paint.CalcTextHeight(g, item.getBar().getItemsFont(), item.getText(), (int)this.getBounds().getWidth() - 2 - 0);
                retVal = height + 36 + 8;
            }
        }
        return retVal;
    }

    private boolean IsItemVisible(Item item) {
        return this.getActiveBar() != null && this.getActiveBar().getItems().contains(item) && this.m_ActiveBarClientRect.contains(item.getBounds().getLocation());
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseModifiers = e.getModifiersEx();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.m_MouseModifiers != 1024) {
            return;
        }
        this.m_MouseModifiers = 0;
        HitInfo hitInfo = new HitInfo(e.getPoint(), this);
        if (hitInfo.getHittedObject() == 1) {
            if (hitInfo.getHittedBar().getIndex() != this.m_ActiveBarIndex) {
                this.m_ActiveBarIndex = hitInfo.getHittedBar().getIndex();
                this.UpdateAll();
                this.OnBarClicked(hitInfo.getHittedBar());
            } else {
                this.repaint();
            }
            return;
        }
        if (hitInfo.getHittedObject() == 2) {
            if (hitInfo.getHittedItem().getAllowStuck()) {
                if (!hitInfo.getHittedItem().equals(this.m_StuckenItem)) {
                    Item oldItem = this.m_StuckenItem;
                    this.m_StuckenItem = hitInfo.getHittedItem();
                    this.OnItemClicked(hitInfo.getHittedItem());
                    this.repaint();
                }
            } else {
                this.OnItemClicked(hitInfo.getHittedItem());
                this.repaint();
            }
        }
        Bar activeBar = this.getActiveBar();
        if (hitInfo.getHittedObject() == 3) {
            activeBar.setFirstVisibleIndex(activeBar.getFirstVisibleIndex() - 1);
            this.UpdateAll();
            return;
        }
        if (hitInfo.getHittedObject() == 4) {
            activeBar.setFirstVisibleIndex(activeBar.getFirstVisibleIndex() + 1);
            this.UpdateAll();
            return;
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.m_MousePos = e.getPoint();
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(0, 0);
        this.DrawHittedObject(this.m_LastHitInfo);
        this.m_LastHitInfo = null;
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.getActiveBar() != null) {
            if (event.getWheelRotation() < 0 && this.getActiveBar().getFirstVisibleIndex() > 0) {
                this.getActiveBar().setFirstVisibleIndex(this.getActiveBar().getFirstVisibleIndex() - 1);
                this.UpdateAll();
            }
            if (event.getWheelRotation() > 0 && !this.getActiveBar().getIsLastVisible()) {
                this.getActiveBar().setFirstVisibleIndex(this.getActiveBar().getFirstVisibleIndex() + 1);
                this.UpdateAll();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        HitInfo hitInfo;
        this.m_MousePos = e.getPoint();
        if (!this.m_NeedCalcDrawInfo && !(hitInfo = new HitInfo(e.getPoint(), this)).Compare(this.m_LastHitInfo)) {
            this.DrawHittedObject(this.m_LastHitInfo);
            this.DrawHittedObject(hitInfo);
            this.m_LastHitInfo = hitInfo;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void UpdateAll() {
        this.m_NeedCalcDrawInfo = true;
        if (this.getBars().size() > 0 && this.m_ActiveBarIndex == -1) {
            this.m_ActiveBarIndex = 0;
        }
        if (!this.m_BeginUpdate) {
            this.repaint();
        }
    }

    public void BeginUpdate() {
        this.m_BeginUpdate = true;
    }

    public void EndUpdate() {
        this.m_BeginUpdate = false;
        this.UpdateAll();
    }

    public HitInfo GetHittedObject() {
        return new HitInfo(this.m_MousePos, this);
    }

    public boolean getUseStaticViewStyle() {
        return this.m_UseStaticViewStyle;
    }

    public void setUseStaticViewStyle(boolean s) {
        if (this.m_UseStaticViewStyle != s) {
            this.m_UseStaticViewStyle = s;
            if (s) {
                ViewStyle.getstaticViewStyle().CopyTo(this.m_ViewStyle);
                this.m_ViewStyle.setReadOnly(true);
            } else {
                this.m_ViewStyle.setReadOnly(false);
            }
        }
    }

    public ViewStyle getViewStyle() {
        return this.m_ViewStyle;
    }

    public ImageList getImageList() {
        return this.m_ImageList;
    }

    public void setImageList(ImageList value) {
        if (value != null) {
            this.m_ImageList = value;
            if (this.getBars().size() > 0) {
                this.repaint();
            }
        }
    }

    public ImageList getImageListSmall() {
        return this.m_ImageListSmall;
    }

    public void setImageListSmall(ImageList value) {
        if (value != null) {
            this.m_ImageListSmall = value;
            if (this.getBars().size() > 0) {
                this.repaint();
            }
        }
    }

    public Bars getBars() {
        return this.m_pBars;
    }

    public Bar getActiveBar() {
        if (this.m_ActiveBarIndex > -1) {
            return (Bar)this.getBars().get(this.m_ActiveBarIndex);
        }
        return null;
    }

    public void setActiveBar(Bar value) {
        if (value != null) {
            this.m_ActiveBarIndex = value.getIndex();
            this.UpdateAll();
        } else {
            this.m_ActiveBarIndex = -1;
            this.UpdateAll();
        }
    }

    public boolean getAllowItemsStuck() {
        return this.m_AllowItemsStuck;
    }

    public void setAllowItemsStuck(boolean value) {
        if (this.m_AllowItemsStuck != value) {
            this.m_AllowItemsStuck = value;
        }
    }

    public Item getStuckenItem() {
        return this.m_StuckenItem;
    }

    public void setStuckenItem(Item value) {
        if (this.m_StuckenItem != value) {
            this.m_StuckenItem = value;
            if (this.m_StuckenItem != null && this.m_StuckenItem.getAllowStuck()) {
                this.setActiveBar(this.m_StuckenItem.getBar());
                this.OnItemClicked(this.m_StuckenItem);
            } else {
                this.m_StuckenItem = null;
            }
            this.repaint();
        }
    }

    public Rectangle getUpScrollBtnRect() {
        if (this.getIsUpScrollBtnVisible()) {
            Rectangle upRect = new Rectangle((int)this.getActiveBar().getBarClientRect().getWidth() - 16, (int)this.getActiveBar().getBarClientRect().getY() + 6, 14, 14);
            return upRect;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public Rectangle getDownScrollBtnRect() {
        if (this.getIsDownScrollBtnVisible()) {
            Rectangle downRect = new Rectangle((int)this.getActiveBar().getBarClientRect().getWidth() - 16, (int)this.getActiveBar().getBarClientRect().getY() + (int)this.getActiveBar().getBarClientRect().getHeight() - 19, 14, 14);
            return downRect;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public boolean getIsUpScrollBtnVisible() {
        return this.getActiveBar() != null && this.getActiveBar().getFirstVisibleIndex() > 0;
    }

    public boolean getIsDownScrollBtnVisible() {
        if (this.getActiveBar() != null) {
            return !this.getActiveBar().getIsLastVisible();
        }
        return false;
    }

    public void addClickedListener(OutlookBarListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("LumiSoft.UI.Controls.WOutlookBar.OutlookBarListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.m_pListners.add(clazz, l);
    }

    public void removeClickedListener(OutlookBarListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("LumiSoft.UI.Controls.WOutlookBar.OutlookBarListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.m_pListners.remove(clazz, l);
    }

    protected void OnItemClicked(Item item) {
        Object[] listeners = this.m_pListners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("LumiSoft.UI.Controls.WOutlookBar.OutlookBarListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((OutlookBarListener)listeners[i + 1]).ItemClicked(this, item);
            }
            ++i;
        }
    }

    protected void OnBarClicked(Bar bar) {
        Object[] listeners = this.m_pListners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("LumiSoft.UI.Controls.WOutlookBar.OutlookBarListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((OutlookBarListener)listeners[i + 1]).BarClicked(this, bar);
            }
            ++i;
        }
    }
}

