/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WOutlookBar;

import LumiSoft.UI.Controls.ViewStyle;
import LumiSoft.UI.Controls.WOutlookBar.Bar;
import LumiSoft.UI.Controls.WOutlookBar.Items;
import LumiSoft.UI.Controls.WOutlookBar.WOutlookBar;
import java.awt.Image;
import java.awt.Rectangle;

public class Item {
    private String m_Text = "";
    private String m_TextID = "";
    private Object m_Tag = null;
    private int m_ImageIndex = -1;
    private boolean m_AllowStuck = true;
    private Items m_pItems = null;
    private Rectangle m_Bounds;

    public Item(Items items) {
        this.m_pItems = items;
        this.m_AllowStuck = this.getWOutlookBar().getAllowItemsStuck();
        this.m_Bounds = new Rectangle(-1, -1, 0, 0);
    }

    private void OnItemNeedsUpdate() {
        this.getWOutlookBar().UpdateAll();
    }

    public String getText() {
        return this.m_Text;
    }

    public void setText(String value) {
        if (this.m_Text != value) {
            this.m_Text = value;
            this.OnItemNeedsUpdate();
        }
    }

    public String getTextID() {
        return this.m_TextID;
    }

    public void setTextID(String value) {
        if (this.m_TextID != value) {
            this.m_TextID = value;
            this.OnItemNeedsUpdate();
        }
    }

    public Object getTag() {
        return this.m_Tag;
    }

    public void setTag(Object value) {
        if (this.m_Tag != value) {
            this.m_Tag = value;
        }
    }

    public int getImageIndex() {
        return this.m_ImageIndex;
    }

    public void setImageIndex(int value) {
        if (this.m_ImageIndex != value) {
            this.m_ImageIndex = value;
            this.OnItemNeedsUpdate();
        }
    }

    public boolean getAllowStuck() {
        return this.m_AllowStuck;
    }

    public void setAllowStuck(boolean value) {
        if (this.m_AllowStuck != value) {
            this.m_AllowStuck = value;
            this.OnItemNeedsUpdate();
        }
    }

    public int getIndex() {
        return this.m_pItems.indexOf(this);
    }

    public Image getImage() {
        if (this.getImageIndex() > -1) {
            if (this.getBar().getItemsStyleCurrent() == 4) {
                if (this.getWOutlookBar().getImageListSmall() != null && this.getImageIndex() < this.getWOutlookBar().getImageListSmall().getCount()) {
                    return this.getWOutlookBar().getImageListSmall().get(this.getImageIndex());
                }
            } else if (this.getWOutlookBar().getImageList() != null && this.getImageIndex() < this.getWOutlookBar().getImageList().getCount()) {
                return this.getWOutlookBar().getImageList().get(this.getImageIndex());
            }
        }
        return null;
    }

    public Rectangle getBounds() {
        return this.m_Bounds;
    }

    public void setBounds(Rectangle value) {
        if (this.m_Bounds != value) {
            this.m_Bounds = value;
        }
    }

    public Rectangle getImageRect() {
        if (this.getBar().getItemsStyleCurrent() == 4) {
            return new Rectangle(3, (int)this.getBounds().getY() + 2, 16, 16);
        }
        return new Rectangle((int)(this.getBounds().getWidth() - 32.0 + 4.0) / 2, (int)this.getBounds().getY() + 4, 32, 32);
    }

    public Rectangle getTextRect() {
        if (this.getBar().getItemsStyleCurrent() == 4) {
            return new Rectangle((int)this.getBounds().getX() + 20, (int)this.getBounds().getY() + 1, (int)this.getBounds().getWidth() - 20, (int)this.getBounds().getHeight() - 2);
        }
        return new Rectangle((int)this.getBounds().getX() + 2, (int)this.getImageRect().getMaxY() + 3, (int)this.getBounds().getWidth(), (int)this.getBounds().getMaxY() - (int)this.getImageRect().getMaxY());
    }

    public Items getItems() {
        return this.m_pItems;
    }

    public Bar getBar() {
        return this.m_pItems.getBar();
    }

    public WOutlookBar getWOutlookBar() {
        return this.m_pItems.getBar().getBars().getWOutlookBar();
    }

    public ViewStyle getViewStyle() {
        return this.m_pItems.getBar().getBars().getWOutlookBar().getViewStyle();
    }
}

