/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WOutlookBar;

import LumiSoft.UI.Controls.WOutlookBar.Bar;
import LumiSoft.UI.Controls.WOutlookBar.Item;
import LumiSoft.UI.Controls.WOutlookBar.WOutlookBar;
import java.awt.Point;

public class HitInfo {
    private int m_HittedObject = 5;
    private Bar m_HittedBar = null;
    private Item m_HittedItem = null;

    public HitInfo(Point hitPoint, WOutlookBar outlookBar) {
        Bar activeBar = outlookBar.getActiveBar();
        int i = 0;
        while (i < outlookBar.getBars().size()) {
            Bar bar = (Bar)outlookBar.getBars().get(i);
            if (bar.getBarRect().contains(hitPoint)) {
                this.m_HittedObject = 1;
                this.m_HittedBar = bar;
                return;
            }
            ++i;
        }
        if (outlookBar.getIsUpScrollBtnVisible() && outlookBar.getUpScrollBtnRect().contains(hitPoint)) {
            this.m_HittedObject = 3;
            return;
        }
        if (outlookBar.getIsDownScrollBtnVisible() && outlookBar.getDownScrollBtnRect().contains(hitPoint)) {
            this.m_HittedObject = 4;
            return;
        }
        if (activeBar != null) {
            int it = activeBar.getFirstVisibleIndex();
            while (it < activeBar.getItems().size()) {
                Item item = (Item)activeBar.getItems().get(it);
                if (item.getBounds().contains(hitPoint) && activeBar.getBarClientRect().contains(hitPoint)) {
                    this.m_HittedObject = 2;
                    this.m_HittedItem = item;
                    return;
                }
                ++it;
            }
        }
        this.m_HittedObject = 5;
    }

    public boolean Compare(HitInfo hitInfo) {
        if (hitInfo == null) {
            return false;
        }
        switch (hitInfo.getHittedObject()) {
            case 1: {
                if (this.m_HittedBar == null || hitInfo.getHittedBar() == null || !hitInfo.getHittedBar().equals(this.m_HittedBar)) break;
                return true;
            }
            case 2: {
                if (this.m_HittedItem == null || hitInfo.getHittedItem() == null || !hitInfo.getHittedItem().equals(this.m_HittedItem)) break;
                return true;
            }
            case 5: {
                if (this.m_HittedObject != 5) break;
                return true;
            }
        }
        return false;
    }

    public int getHittedObject() {
        return this.m_HittedObject;
    }

    public Bar getHittedBar() {
        return this.m_HittedBar;
    }

    public Item getHittedItem() {
        return this.m_HittedItem;
    }
}

