/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WOutlookBar;

import LumiSoft.UI.Controls.WOutlookBar.Bars;
import LumiSoft.UI.Controls.WOutlookBar.Item;
import LumiSoft.UI.Controls.WOutlookBar.Items;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

public class Bar {
    private int m_TextAlign = 1;
    private int m_ItemsTextAlign = 1;
    private String m_Caption = "";
    private String m_TextID = "";
    private Color m_TextColor = Color.black;
    private Font m_Font = null;
    private Object m_Tag = null;
    private Items m_pItems = null;
    private Color m_ItemsTextColor = Color.black;
    private Font m_ItemsFont = null;
    private int m_ItemsStyle = 7;
    private Color m_BarBackColor = Color.lightGray;
    private Color m_ItemsBackColor = Color.yellow;
    private Bars m_pBars = null;
    private Rectangle m_BarRect;
    private Rectangle m_BarClientRect;
    private int m_FirstVisibleItem = 0;

    public Bar(Bars bars) {
        this.m_pItems = new Items(this);
        this.m_pBars = bars;
    }

    protected void OnBarNeedsUpdate() {
        this.m_pBars.getWOutlookBar().UpdateAll();
    }

    public String getText() {
        return this.m_Caption;
    }

    public void setText(String value) {
        if (this.m_Caption != value) {
            this.m_Caption = value;
            this.OnBarNeedsUpdate();
        }
    }

    public String getTextID() {
        return this.m_TextID;
    }

    public void setTextID(String value) {
        if (this.m_TextID != value) {
            this.m_TextID = value;
            this.OnBarNeedsUpdate();
        }
    }

    public int getTextAlign() {
        return this.m_TextAlign;
    }

    public void setTextAlign(int value) {
        if (this.m_TextAlign != value) {
            this.m_TextAlign = value;
            this.OnBarNeedsUpdate();
        }
    }

    public Object getTag() {
        return this.m_Tag;
    }

    public void setTag(Object value) {
        if (this.m_Tag != value) {
            this.m_Tag = value;
        }
    }

    public Font getFont() {
        if (this.m_Font == null) {
            return this.m_pBars.getWOutlookBar().getFont();
        }
        return this.m_Font;
    }

    public void setFont(Font value) {
        if (this.m_Font != value) {
            this.m_Font = value;
            this.OnBarNeedsUpdate();
        }
    }

    public int getIndex() {
        return this.m_pBars.indexOf(this);
    }

    public Items getItems() {
        return this.m_pItems;
    }

    public int getItemsTextAlign() {
        return this.m_ItemsTextAlign;
    }

    public void setItemsTextAlign(int value) {
        if (this.m_ItemsTextAlign != value) {
            this.m_ItemsTextAlign = value;
            this.OnBarNeedsUpdate();
        }
    }

    public int getItemsStyle() {
        return this.m_ItemsStyle;
    }

    public void setItemsStyle(int value) {
        if (this.m_ItemsStyle != value) {
            this.m_ItemsStyle = value;
            this.m_ItemsTextAlign = value == 4 ? 2 : 1;
            this.OnBarNeedsUpdate();
        }
    }

    public Font getItemsFont() {
        if (this.m_ItemsFont == null) {
            return this.m_pBars.getWOutlookBar().getFont();
        }
        return this.m_ItemsFont;
    }

    public void setItemsFont(Font value) {
        if (this.m_ItemsFont != value) {
            this.m_ItemsFont = value;
            this.OnBarNeedsUpdate();
        }
    }

    public int getItemsStyleCurrent() {
        int itemStyle = this.getItemsStyle();
        if (this.getItemsStyle() == 7) {
            itemStyle = this.getBars().getWOutlookBar().getViewStyle().getBarItemsStyle();
        }
        if (itemStyle == 7) {
            itemStyle = 2;
        }
        return itemStyle;
    }

    public Rectangle getBarRect() {
        return this.m_BarRect;
    }

    public void setBarRect(Rectangle value) {
        if (this.m_BarRect != value) {
            this.m_BarRect = value;
        }
    }

    public Rectangle getBarClientRect() {
        return this.m_BarClientRect;
    }

    public void setBarClientRect(Rectangle value) {
        if (this.m_BarClientRect != value) {
            this.m_BarClientRect = value;
        }
    }

    public int getFirstVisibleIndex() {
        return this.m_FirstVisibleItem;
    }

    public void setFirstVisibleIndex(int value) {
        if (this.m_FirstVisibleItem != value) {
            this.m_FirstVisibleItem = value;
        }
    }

    public boolean getIsLastVisible() {
        return this.getItems().size() < 1 || this.getBarClientRect().contains(((Item)this.getItems().get(this.getItems().size() - 1)).getBounds());
    }

    public Bars getBars() {
        return this.m_pBars;
    }
}

