/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WTab;

import LumiSoft.UI.Controls.ImageList;
import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.ViewStyle;
import LumiSoft.UI.Controls.WTab.Tab;
import LumiSoft.UI.Controls.WTab.TabListener;
import LumiSoft.UI.Controls.WTab.Tabs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class WTabBar
extends JPanel
implements MouseListener,
MouseMotionListener {
    private EventListenerList m_pListners = null;
    private Tabs m_pTabs = null;
    private Tab m_pSelectedTab = null;
    private int m_FVisibleTabIndex = 0;
    private ImageList m_ImageList = null;
    private Object m_ActiveObj = null;
    private Point m_MousePos = new Point(0, 0);
    private int m_MouseModifiers = 0;
    static /* synthetic */ Class class$0;

    public WTabBar() {
        this.m_pTabs = new Tabs(this);
        this.m_pListners = new EventListenerList();
        this.setMinimumSize(new Dimension(50, 22));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        this.CalcDrawInfo((Graphics2D)g);
        this.DrawTabs((Graphics2D)g);
        this.DrawButtons((Graphics2D)g);
    }

    private void DrawTabs(Graphics2D g) {
        Rectangle clientRect = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(ViewStyle.GetColorFromRgb(247, 243, 233));
        g.fill(clientRect);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 2);
        Shape clip = g.getClip();
        g.setClip(new Rectangle(0, 0, this.getWidth() - (int)this.getBtnsRect().getWidth(), this.getHeight()));
        int i = 0;
        while (i < this.m_pTabs.size()) {
            boolean hot;
            Tab tab = (Tab)this.getTabs().get(i);
            boolean bl = hot = tab.getBounds().contains(this.m_MousePos) && !this.getBtnsRect().contains(this.m_MousePos);
            if (tab.getBounds().x > -1 && clip.getBounds().intersects(tab.getBounds())) {
                this.DrawTab(g, tab, hot, tab.equals(this.m_pSelectedTab));
            }
            ++i;
        }
        g.setClip(clip);
    }

    private void DrawTab(Graphics2D g, Tab tab, boolean hot, boolean selected) {
        if (selected) {
            g.setColor(ViewStyle.GetColorFromRgb(212, 208, 200));
            g.fill(new Rectangle(tab.getBounds().x - 1, tab.getBounds().y + 3, tab.getBounds().width, tab.getBounds().height - 3));
        }
        if (hot) {
            if (tab.getEnabled()) {
                g.setColor(Color.BLUE);
            } else {
                g.setColor(Color.RED);
            }
        } else if (selected) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.GRAY);
        }
        Paint.DrawText(g, this.getFont(), tab.getText(), tab.getTextRect(), 2);
        if (selected) {
            g.setColor(Color.BLACK);
            g.drawLine((int)tab.getBounds().getMaxX() - 1, 4, (int)tab.getBounds().getMaxX() - 1, this.getHeight() - 3);
        } else {
            g.setColor(Color.GRAY);
            g.drawLine((int)tab.getBounds().getMaxX() - 1, 4, (int)tab.getBounds().getMaxX() - 1, this.getHeight() - 6);
        }
        if (this.m_ImageList != null && tab.getImageIndex() > -1 && tab.getImageIndex() < this.m_ImageList.getCount()) {
            if (tab.getEnabled()) {
                g.drawImage(this.m_ImageList.get(tab.getImageIndex()), tab.getImageRect().x, tab.getImageRect().y, this);
            } else {
                g.drawImage(this.m_ImageList.get(tab.getImageIndex()), tab.getImageRect().x, tab.getImageRect().y, this);
            }
        }
    }

    private Rectangle GetArrowRect(Rectangle rect) {
        int w = rect.width - 11;
        int h = rect.height - 7;
        int x = rect.x + (rect.width - w) / 2;
        int y = rect.y + (rect.height - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    private void DrawButtons(Graphics2D g) {
        g.setColor(ViewStyle.GetColorFromRgb(212, 208, 200));
        g.fillRect(this.getBtnsRect().x, this.getBtnsRect().y - 1, this.getBtnsRect().width, this.getBtnsRect().height + 1);
        Rectangle rect = null;
        g.setColor(Color.BLACK);
        if (!this.getIsFirstBtnEnabled()) {
            g.setColor(Color.GRAY);
        }
        rect = this.GetArrowRect(this.getFirstBtnRect());
        Paint.DrawTriangle(g, rect, 3);
        g.drawLine(rect.x - 2, rect.y, rect.x - 2, (int)rect.getMaxY() - 1);
        g.setColor(Color.BLACK);
        if (!this.getIsPrevBtnEnabled()) {
            g.setColor(Color.GRAY);
        }
        rect = this.GetArrowRect(this.getPrevBtnRect());
        Paint.DrawTriangle(g, rect, 3);
        g.setColor(Color.BLACK);
        if (!this.getIsNextBtnEnabled()) {
            g.setColor(Color.GRAY);
        }
        rect = this.GetArrowRect(this.getNextBtnRect());
        Paint.DrawTriangle(g, rect, 4);
        g.setColor(Color.BLACK);
        if (!this.getIsLastBtnEnabled()) {
            g.setColor(Color.GRAY);
        }
        rect = this.GetArrowRect(this.getLastBtnRect());
        Paint.DrawTriangle(g, rect, 4);
        g.drawLine((int)rect.getMaxX() + 1, rect.y, (int)rect.getMaxX() + 1, (int)rect.getMaxY() - 1);
        if (this.getFirstBtnRect().contains(this.m_MousePos)) {
            g.setColor(Color.WHITE);
            g.drawLine(this.getFirstBtnRect().x - 1, 1, this.getFirstBtnRect().x - 1, this.getHeight() - 4);
            g.drawLine(this.getFirstBtnRect().x - 1, 1, (int)this.getFirstBtnRect().getMaxX() - 1, 1);
            g.setColor(Color.GRAY);
            g.drawLine((int)this.getFirstBtnRect().getMaxX() - 1, 1, (int)this.getFirstBtnRect().getMaxX() - 1, this.getHeight() - 4);
        }
        if (this.getPrevBtnRect().contains(this.m_MousePos)) {
            g.setColor(Color.WHITE);
            g.drawLine(this.getPrevBtnRect().x - 1, 1, this.getPrevBtnRect().x - 1, this.getHeight() - 4);
            g.drawLine(this.getPrevBtnRect().x - 1, 1, (int)this.getPrevBtnRect().getMaxX() - 1, 1);
            g.setColor(Color.GRAY);
            g.drawLine((int)this.getPrevBtnRect().getMaxX() - 1, 1, (int)this.getPrevBtnRect().getMaxX() - 1, this.getHeight() - 4);
        }
        if (this.getNextBtnRect().contains(this.m_MousePos)) {
            g.setColor(Color.WHITE);
            g.drawLine(this.getNextBtnRect().x - 1, 1, this.getNextBtnRect().x - 1, this.getHeight() - 4);
            g.drawLine(this.getNextBtnRect().x - 1, 1, (int)this.getNextBtnRect().getMaxX() - 1, 1);
            g.setColor(Color.GRAY);
            g.drawLine((int)this.getNextBtnRect().getMaxX() - 1, 1, (int)this.getNextBtnRect().getMaxX() - 1, this.getHeight() - 4);
        }
        if (this.getLastBtnRect().contains(this.m_MousePos)) {
            g.setColor(Color.WHITE);
            g.drawLine(this.getLastBtnRect().x - 1, 1, this.getLastBtnRect().x - 1, this.getHeight() - 4);
            g.drawLine(this.getLastBtnRect().x - 1, 1, (int)this.getLastBtnRect().getMaxX() - 1, 1);
            g.setColor(Color.GRAY);
            g.drawLine((int)this.getLastBtnRect().getMaxX() - 1, 1, (int)this.getLastBtnRect().getMaxX() - 1, this.getHeight() - 4);
        }
    }

    private void CalcDrawInfo(Graphics2D g) {
        int tRight = 5;
        int i = 0;
        while (i < this.m_pTabs.size()) {
            Tab tab = (Tab)this.getTabs().get(i);
            if (i >= this.m_FVisibleTabIndex) {
                int width = this.CalcTabWidth(g, tab) + 10;
                tab.setBounds(new Rectangle(tRight, 1, width, this.getHeight() - 1));
                tRight += width;
            } else {
                tab.setBounds(new Rectangle(-1, -1, 0, 0));
            }
            ++i;
        }
    }

    private int CalcTabWidth(Graphics2D g, Tab tab) {
        int size = Paint.CalcTextWidth(g, this.getFont(), tab.getText());
        if (tab.getImageIndex() > -1) {
            size += 20;
        }
        return size;
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseModifiers = e.getModifiersEx();
    }

    public void mouseReleased(MouseEvent e) {
        this.m_MouseModifiers = 0;
        if (this.getBtnsRect().contains(this.m_MousePos)) {
            if (this.getIsFirstBtnEnabled() && this.getFirstBtnRect().contains(this.m_MousePos)) {
                this.m_FVisibleTabIndex = 0;
            }
            if (this.getIsPrevBtnEnabled() && this.getPrevBtnRect().contains(this.m_MousePos)) {
                --this.m_FVisibleTabIndex;
            }
            if (this.getIsNextBtnEnabled() && this.getNextBtnRect().contains(this.m_MousePos)) {
                ++this.m_FVisibleTabIndex;
            }
            if (this.getIsLastBtnEnabled() && this.getLastBtnRect().contains(this.m_MousePos)) {
                Tab lastTab = (Tab)this.getTabs().get(this.getTabs().size() - 1);
                while (this.m_FVisibleTabIndex < this.getTabs().size() - 1) {
                    ++this.m_FVisibleTabIndex;
                    if (lastTab.getBounds().getMaxX() < (double)this.getBtnsRect().x) break;
                }
            }
            this.repaint();
            return;
        }
        int i = 0;
        while (i < this.m_pTabs.size()) {
            Tab tab = (Tab)this.getTabs().get(i);
            if (tab.getBounds().contains(this.m_MousePos) && tab.getEnabled() && !tab.equals(this.getSelectedTab())) {
                this.setSelectedTab(tab);
                this.MakeTabVisible(tab);
                break;
            }
            ++i;
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
        Object activeItem = "";
        if (this.getBtnsRect().contains(this.m_MousePos)) {
            if (this.getFirstBtnRect().contains(this.m_MousePos)) {
                activeItem = "FirstButton";
            }
            if (this.getPrevBtnRect().contains(this.m_MousePos)) {
                activeItem = "PrevButton";
            }
            if (this.getNextBtnRect().contains(this.m_MousePos)) {
                activeItem = "NextButton";
            }
            if (this.getLastBtnRect().contains(this.m_MousePos)) {
                activeItem = "LastButton";
            }
        } else {
            Tab t = this.GetMouseTab();
            activeItem = t != null ? t : "tabcontrol";
        }
        if (activeItem != this.m_ActiveObj) {
            this.m_ActiveObj = activeItem;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        this.m_MouseModifiers = 0;
        this.m_ActiveObj = null;
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    private Tab GetMouseTab() {
        int i = 0;
        while (i < this.m_pTabs.size()) {
            Tab tab = (Tab)this.getTabs().get(i);
            if (tab.getBounds().contains(this.m_MousePos)) {
                return tab;
            }
            ++i;
        }
        return null;
    }

    public void MakeTabVisible(Tab tab) {
        if (tab.getBounds().x < 0 || tab.getBounds().getMaxX() > (double)this.getBtnsRect().x) {
            while (this.m_FVisibleTabIndex < this.getTabs().size() - 1) {
                ++this.m_FVisibleTabIndex;
                this.CalcDrawInfo((Graphics2D)this.getGraphics());
                if (tab.getBounds().getMaxX() < (double)this.getBtnsRect().x) break;
            }
            this.repaint();
        }
    }

    public Tabs getTabs() {
        return this.m_pTabs;
    }

    public Tab getSelectedTab() {
        return this.m_pSelectedTab;
    }

    public void setSelectedTab(Tab s) {
        if (this.m_pSelectedTab != s) {
            this.OnSelectedTabChanged(s, this.m_pSelectedTab);
            this.m_pSelectedTab = s;
            this.repaint();
        }
    }

    public ImageList getImageList() {
        return this.m_ImageList;
    }

    public void setImageList(ImageList s) {
        if (this.m_ImageList != s) {
            this.m_ImageList = s;
            this.repaint();
        }
    }

    private Rectangle getBtnsRect() {
        return new Rectangle(this.getWidth() - 68, 2, 67, this.getHeight() - 4);
    }

    private Rectangle getFirstBtnRect() {
        return new Rectangle(this.getWidth() - 67, 5, 16, 16);
    }

    private Rectangle getPrevBtnRect() {
        return new Rectangle(this.getWidth() - 51, 5, 16, 16);
    }

    private Rectangle getNextBtnRect() {
        return new Rectangle(this.getWidth() - 34, 5, 16, 16);
    }

    private Rectangle getLastBtnRect() {
        return new Rectangle(this.getWidth() - 17, 5, 16, 16);
    }

    private boolean getIsFirstBtnEnabled() {
        if (this.m_pTabs.size() > 0) {
            Tab t = (Tab)this.getTabs().get(0);
            if (t.getBounds().x < 1) {
                return true;
            }
        }
        return false;
    }

    private boolean getIsPrevBtnEnabled() {
        if (this.m_pTabs.size() > 0) {
            Tab t = (Tab)this.getTabs().get(0);
            if (t.getBounds().x > 5 || this.m_FVisibleTabIndex > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean getIsNextBtnEnabled() {
        Tab t;
        return this.m_pTabs.size() > 0 && (t = (Tab)this.getTabs().get(this.getTabs().size() - 1)).getBounds().getMaxX() > (double)this.getBtnsRect().x;
    }

    private boolean getIsLastBtnEnabled() {
        Tab t;
        return this.m_pTabs.size() > 0 && (t = (Tab)this.getTabs().get(this.getTabs().size() - 1)).getBounds().getMaxX() > (double)this.getBtnsRect().x;
    }

    public void addTabChangedListener(TabListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("LumiSoft.UI.Controls.WTab.TabListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.m_pListners.add(clazz, l);
    }

    public void removeTabChangedListener(TabListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("LumiSoft.UI.Controls.WTab.TabListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.m_pListners.remove(clazz, l);
    }

    protected void OnSelectedTabChanged(Tab newTab, Tab oldTab) {
        Object[] listeners = this.m_pListners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("LumiSoft.UI.Controls.WTab.TabListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((TabListener)listeners[i + 1]).TabChanged(this, newTab, oldTab);
            }
            ++i;
        }
    }
}

