/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.ViewStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class WScrollBar
extends JPanel
implements MouseListener,
MouseMotionListener {
    private ViewStyle m_ViewStyle = null;
    private int m_Minimum = 0;
    private int m_Maximum = 2;
    private int m_Position = 0;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;
    private String m_HittedObject = "";

    public WScrollBar() {
        this.m_ViewStyle = new ViewStyle();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        this.Paint((Graphics2D)g);
    }

    private void Paint(Graphics2D g) {
        Rectangle clientRect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.LIGHT_GRAY);
        g.fill(clientRect);
        g.setColor(Color.CYAN);
        g.fill(new Rectangle(clientRect.x, this.GetScrollPaneY(), clientRect.width - 3, this.GetScrollPaneHeight()));
        g.setColor(this.m_ViewStyle.GetButtonColor(this.getDecreaseButtonRect().contains(this.m_MousePos), this.m_MouseModifiers == 1024));
        g.fill(this.getDecreaseButtonRect());
        g.setColor(Color.BLACK);
        Paint.DrawTriangle(g, this.getTriangleRect(this.getDecreaseButtonRect()), 1);
        g.setColor(this.m_ViewStyle.GetBorderColor(this.getDecreaseButtonRect().contains(this.m_MousePos)));
        g.draw(this.getDecreaseButtonRect());
        g.setColor(this.m_ViewStyle.GetButtonColor(this.getIncreaseButtonRect().contains(this.m_MousePos), this.m_MouseModifiers == 1024));
        g.fill(this.getIncreaseButtonRect());
        g.setColor(Color.BLACK);
        Paint.DrawTriangle(g, this.getTriangleRect(this.getIncreaseButtonRect()), 2);
        g.setColor(this.m_ViewStyle.GetBorderColor(this.getIncreaseButtonRect().contains(this.m_MousePos)));
        g.draw(this.getIncreaseButtonRect());
    }

    private Rectangle getTriangleRect(Rectangle buttonRect) {
        return new Rectangle(buttonRect.x + 4, buttonRect.y + 7, buttonRect.width - 7, buttonRect.height - 12);
    }

    private int GetScrollPaneY() {
        int y = 18;
        if (this.m_Position != 0) {
            y = this.m_Position < this.getMaximum() ? (y += (this.getHeight() - 36 - this.GetScrollPaneHeight()) / this.getMaximum() * this.m_Position) : this.getHeight() - 18 - this.GetScrollPaneHeight();
        }
        return y;
    }

    private int GetScrollPaneHeight() {
        int height = (this.getHeight() - 34) / this.getMaximum();
        if (height < 12) {
            height = 12;
        }
        return height;
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseModifiers = e.getModifiersEx();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.m_MouseModifiers = 0;
        if (this.getDecreaseButtonRect().contains(e.getPoint()) && this.m_Position > this.m_Minimum) {
            --this.m_Position;
        } else if (this.getIncreaseButtonRect().contains(e.getPoint()) && this.m_Position < this.m_Maximum) {
            ++this.m_Position;
        }
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        this.m_HittedObject = "";
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
        String hittedObject = "";
        if (this.getDecreaseButtonRect().contains(e.getPoint())) {
            hittedObject = "DecreaseButton";
        } else if (this.getIncreaseButtonRect().contains(e.getPoint())) {
            hittedObject = "IncreaseButton";
        }
        if (!this.m_HittedObject.equals(hittedObject)) {
            this.m_HittedObject = hittedObject;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    private Rectangle getDecreaseButtonRect() {
        return new Rectangle(0, 0, 17, 17);
    }

    private Rectangle getIncreaseButtonRect() {
        return new Rectangle(0, this.getHeight() - 18, 17, 17);
    }

    public int getMinimum() {
        return this.m_Minimum;
    }

    public void setMinimum(int value) {
        if (this.m_Minimum != value) {
            this.m_Minimum = value;
        }
    }

    public int getMaximum() {
        return this.m_Maximum;
    }

    public void setMaximum(int value) {
        if (this.m_Maximum != value) {
            this.m_Maximum = value;
        }
    }

    public int getPosition() {
        return this.m_Position;
    }

    public void setPosition(int value) {
        if (this.m_Position != value) {
            this.m_Position = value;
        }
    }
}

