/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import LumiSoft.UI.Controls.WEditBox_base;
import LumiSoft.UI.Controls.WSpinEdit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class WNumericEdit
extends WSpinEdit
implements FocusListener {
    private WEditBox_base m_pTextbox = new WEditBox_base();
    private int m_SpinnerStep = 1;

    public WNumericEdit() {
        this.m_pTextbox.setBorder(null);
        this.m_pTextbox.addFocusListener(this);
        this.m_pTextbox.addMouseListener(this);
        this.m_pTextbox.addMouseMotionListener(this);
        this.m_pTextbox.setText("0");
        this.add(this.m_pTextbox);
    }

    protected void SizeChanged() {
        this.m_pTextbox.setBounds(this.getEditRect());
    }

    public void focusGained(FocusEvent e) {
        this.m_pTextbox.selectAll();
        this.m_pTextbox.setBackground(this.m_ViewStyle.GetEditColor(this.getReadOnly(), true, true));
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.m_pTextbox.setBackground(this.m_ViewStyle.GetEditColor(this.getReadOnly(), true, false));
        this.repaint();
    }

    public int getValue() {
        return 0;
    }

    public void setValue(double value) {
        this.m_pTextbox.setText(String.valueOf(value));
    }

    public int getMaximumValue() {
        return 0;
    }

    public void setMaximumValue(int value) {
    }

    public int getMinimumValue() {
        return 0;
    }

    public void setMinimumValue(int value) {
    }

    public int getDecimalPlaces() {
        return this.m_pTextbox.getDecimalPlaces();
    }

    public void setDecimalPlaces(int value) {
        this.m_pTextbox.setDecimalPlaces(value);
    }

    public int getSpinnerStep() {
        return this.m_SpinnerStep;
    }

    public void setSpinnerStep(int value) {
        if (this.m_SpinnerStep != value) {
            this.m_SpinnerStep = value;
        }
    }

    public int getTextAlign() {
        return this.m_pTextbox.getTextAlign();
    }

    public void setTextAlign(int value) {
        this.m_pTextbox.setTextAlign(value);
    }

    public boolean getReadOnly() {
        return this.m_pTextbox.getReadOnly();
    }

    public void setReadOnly(boolean value) {
        this.m_pTextbox.setReadOnly(value);
        this.m_pTextbox.setBackground(this.m_ViewStyle.GetEditColor(value, this.isEnabled(), false));
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.m_pTextbox.setEnabled(value);
        this.m_pTextbox.setBackground(this.m_ViewStyle.GetEditColor(this.getReadOnly(), value, false));
    }

    protected void OnUpButtonClicked() {
        super.OnUpButtonClicked();
        if (!this.getReadOnly()) {
            this.setValue(Double.parseDouble(this.m_pTextbox.getText()) + (double)this.m_SpinnerStep);
        }
    }

    protected void OnDownButtonClicked() {
        super.OnDownButtonClicked();
        if (!this.getReadOnly()) {
            this.setValue(Double.parseDouble(this.m_pTextbox.getText()) - (double)this.m_SpinnerStep);
        }
    }
}

