/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class WEditBox_base
extends JTextField
implements KeyListener,
FocusListener {
    private boolean m_ReadOnly = false;
    private int m_DecPlaces = 3;
    private int m_TextAlign = 2;
    private int m_EditType = 1;

    public WEditBox_base() {
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void keyTyped(KeyEvent e) {
        if (this.m_ReadOnly) {
            e.consume();
            return;
        }
        if (this.m_EditType == 1 && this.Handle_Numeric(e.getKeyChar())) {
            e.consume();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.UpdateUI();
    }

    private boolean Handle_Numeric(char pressedChar) {
        char decSep = '.';
        String text = this.getText();
        boolean isSeparator = text.indexOf(decSep) > -1;
        int sepPos = text.indexOf(decSep);
        if (pressedChar == ',' || pressedChar == '.') {
            pressedChar = decSep;
        }
        if (this.IsDigit(pressedChar) || pressedChar == decSep || pressedChar == '-') {
            text = String.valueOf(text.substring(0, this.getSelectionStart())) + pressedChar + text.substring(this.getSelectionEnd());
        }
        if (pressedChar == decSep) {
            if (!isSeparator) {
                if (text.equals(String.valueOf(decSep))) {
                    this.setText("0" + decSep);
                    return true;
                }
                if (text.length() - text.indexOf(decSep) - 1 > this.m_DecPlaces) {
                    return true;
                }
            } else if (this.getText().indexOf(decSep) > -1) {
                this.setSelectionStart(this.getText().indexOf(decSep) + 1);
                return true;
            }
            int start = this.getCaretPosition();
            this.setText(text);
            this.setCaretPosition(start + 1);
            return true;
        }
        if (pressedChar == '-') {
            if (this.getSelectionStart() > 0 || this.getText().startsWith("-")) {
                return true;
            }
        } else {
            if (pressedChar == '\b') {
                return false;
            }
            if (this.IsDigit(pressedChar)) {
                if (text.startsWith("0") && text.length() > 1 && text.indexOf(decSep) != 1) {
                    if (this.getSelectionStart() == 1 && text.length() == 2) {
                        this.setText("" + pressedChar);
                    }
                    return true;
                }
                if (text.startsWith("-0") && text.length() > 2 && text.indexOf(decSep) != 2) {
                    if (this.getSelectionStart() == 2 && text.length() == 3) {
                        this.setText("" + pressedChar);
                    }
                    return true;
                }
                if (isSeparator && this.getSelectionStart() > sepPos) {
                    if (this.getSelectionStart() - sepPos > this.m_DecPlaces) {
                        return true;
                    }
                    if (text.length() - sepPos > this.m_DecPlaces) {
                        String newVal = text.substring(0, this.getSelectionStart());
                        newVal = String.valueOf(newVal) + pressedChar;
                        this.setText(newVal);
                        this.setSelectionStart(this.getSelectionStart() + 1);
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.getText().length() == 0 || this.getText() == "-") {
            this.setText("0");
        }
    }

    private boolean IsDigit(char c) {
        switch (c) {
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
        }
        return false;
    }

    private boolean IsNumber(String text) {
        try {
            text = text.replaceAll(",", ".");
            Double.parseDouble(text);
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    private void UpdateUI() {
        if (this.getText().startsWith("-")) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(Color.BLACK);
        }
    }

    public void setText(String value) {
        super.setText(value);
        this.UpdateUI();
    }

    public boolean getReadOnly() {
        return this.m_ReadOnly;
    }

    public void setReadOnly(boolean value) {
        if (this.m_ReadOnly != value) {
            this.m_ReadOnly = value;
        }
    }

    public int getDecimalPlaces() {
        return this.m_DecPlaces;
    }

    public void setDecimalPlaces(int value) {
        if (this.m_DecPlaces != value) {
            this.m_DecPlaces = value;
        }
    }

    public int getTextAlign() {
        return this.m_TextAlign;
    }

    public void setTextAlign(int value) {
        if (this.m_TextAlign != value) {
            switch (value) {
                case 2: {
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 1: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 3: {
                    this.setHorizontalAlignment(4);
                }
            }
        }
        this.m_TextAlign = value;
    }

    protected int getEditType() {
        return this.m_EditType;
    }

    protected void setEditType(int value) {
        if (this.m_EditType != value) {
            this.m_EditType = value;
        }
    }

    protected class _EditType {
        public static final int Numeric = 1;
        public static final int Text = 2;

        protected _EditType() {
        }
    }
}

