/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WComboBox;

import LumiSoft.UI.Controls.WButtonEdit;
import LumiSoft.UI.Controls.WComboBox.WComboItem;
import LumiSoft.UI.Controls.WComboBox.WComboItems;
import LumiSoft.UI.Controls.WComboBox.WComboPopUp;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class WComboBox
extends WButtonEdit
implements FocusListener,
KeyListener {
    private JTextField m_pTextbox = null;
    private int m_MaxVisibleItems = 10;
    private WComboItems m_pItems = new WComboItems();
    private boolean m_AcceptsAddKey = true;
    private int m_EditStyle = 4;
    private WComboItem m_pSelectedItem = null;

    public WComboBox() {
        this.m_pTextbox = new JTextField();
        this.m_pTextbox.setBorder(null);
        this.m_pTextbox.addFocusListener(this);
        this.m_pTextbox.addMouseListener(this);
        this.m_pTextbox.addMouseMotionListener(this);
        this.m_pTextbox.addKeyListener(this);
        this.add(this.m_pTextbox);
    }

    public void focusGained(FocusEvent e) {
        this.m_pTextbox.selectAll();
        this.m_pTextbox.setBackground(this.m_ViewStyle.GetEditColor(this.isReadOnly(), true, true));
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.m_pTextbox.setBackground(this.m_ViewStyle.GetEditColor(this.isReadOnly(), true, false));
        this.repaint();
    }

    public void keyTyped(KeyEvent e) {
        if (this.m_AcceptsAddKey && e.getKeyChar() == '+') {
            this.OnButtonClicked();
            e.consume();
        }
        KeyListener[] listeners = this.getKeyListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].keyTyped(e);
            ++i;
        }
    }

    public void keyPressed(KeyEvent e) {
        KeyListener[] listeners = this.getKeyListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].keyPressed(e);
            ++i;
        }
    }

    public void keyReleased(KeyEvent e) {
        KeyListener[] listeners = this.getKeyListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].keyReleased(e);
            ++i;
        }
    }

    protected void OnPopupItemSelected(WComboItem item) {
        if (item != null) {
            this.m_pTextbox.setText(item.toString());
            this.m_pSelectedItem = item;
        }
    }

    protected void OnPopupClosed() {
    }

    protected void SizeChanged() {
        this.m_pTextbox.setLocation(this.getEditRect().getLocation());
        this.m_pTextbox.setSize(this.getEditRect().getSize());
    }

    protected void OnButtonClicked() {
        super.OnButtonClicked();
        if (!this.m_pTextbox.hasFocus()) {
            this.m_pTextbox.grabFocus();
        }
        WComboPopUp m_pPopup = new WComboPopUp(this);
        m_pPopup.show(this, 0, this.getHeight());
    }

    public void SelectItemByTag(Object itemTag) {
        int i = 0;
        while (i < this.getItems().size()) {
            WComboItem item = (WComboItem)this.getItems().get(i);
            if (itemTag.equals(item.getTag())) {
                this.m_pSelectedItem = item;
                this.m_pTextbox.setText(item.getText());
                return;
            }
            ++i;
        }
    }

    public void SelectItemByText(String text) {
        int i = 0;
        while (i < this.getItems().size()) {
            WComboItem item = (WComboItem)this.getItems().get(i);
            if (item.getText().equals(text)) {
                this.m_pSelectedItem = item;
                this.m_pTextbox.setText(item.getText());
                return;
            }
            ++i;
        }
    }

    public WComboItem getSelectedItem() {
        return this.m_pSelectedItem;
    }

    public int getSelectedIndex() {
        if (this.m_pSelectedItem != null && this.getItems().contains(this.m_pSelectedItem)) {
            return this.getItems().indexOf(this.m_pSelectedItem);
        }
        return -1;
    }

    public void setSelectedIndex(int value) {
        if (value > -1 && value < this.getItems().size()) {
            this.m_pSelectedItem = (WComboItem)this.getItems().get(value);
            this.m_pTextbox.setText(this.m_pSelectedItem.getText());
        }
    }

    public int getSelectionStart() {
        return this.m_pTextbox.getSelectionStart();
    }

    public void setSelectionStart(int value) {
        this.m_pTextbox.setSelectionStart(value);
    }

    public int getSelectionEnd() {
        return this.m_pTextbox.getSelectionEnd();
    }

    public void setSelectionEnd(int value) {
        this.m_pTextbox.setSelectionEnd(value);
    }

    public int getMaxVisibleItems() {
        return this.m_MaxVisibleItems;
    }

    public void setMaxVisibleItems(int value) {
        if (this.m_MaxVisibleItems != value) {
            this.m_MaxVisibleItems = value;
        }
    }

    public int getEditStyle() {
        return this.m_EditStyle;
    }

    public void setEditStyle(int value) {
        if (this.m_EditStyle != value) {
            this.m_EditStyle = value;
            switch (value) {
                case 4: {
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
    }

    public boolean getAcceptsAddKey() {
        return this.m_AcceptsAddKey;
    }

    public void setAcceptsAddKey(boolean value) {
        if (this.m_AcceptsAddKey != value) {
            this.m_AcceptsAddKey = value;
        }
    }

    public WComboItems getItems() {
        return this.m_pItems;
    }

    public String getText() {
        return this.m_pTextbox.getText();
    }

    public void setText(String text) {
        this.m_pTextbox.setText(text);
    }

    private boolean isReadOnly() {
        return this.m_EditStyle == 0 || this.m_EditStyle == 2;
    }
}

