/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import LumiSoft.UI.Controls.ViewStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class WCheckBox
extends JPanel
implements FocusListener,
KeyListener,
MouseListener,
MouseMotionListener {
    private boolean m_UseStaticViewStyle = true;
    private ViewStyle m_ViewStyle = null;
    private boolean m_Checked = false;
    private boolean m_ReadOnly = false;
    private int m_CheckAreaAlign = 2;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;

    public WCheckBox() {
        this.m_ViewStyle = new ViewStyle();
        this.setFocusable(true);
        this.setOpaque(false);
        this.setMinimumSize(new Dimension(12, 12));
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        Rectangle clientRect = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        boolean hot = this.hasFocus() || clientRect.contains(this.m_MousePos);
        this.DrawControl((Graphics2D)g, hot);
    }

    private void DrawControl(Graphics2D g, boolean hot) {
        g.setColor(this.m_ViewStyle.GetEditColor(this.getReadOnly(), this.isEnabled(), this.hasFocus()));
        g.fill(this.getCheckRect());
        if (this.m_Checked) {
            g.setColor(Color.BLACK);
            g.drawLine(this.getCheckRect().x + 3, this.getCheckRect().y + 5, this.getCheckRect().x + 3, this.getCheckRect().y + 5 + 2);
            g.drawLine(this.getCheckRect().x + 4, this.getCheckRect().y + 6, this.getCheckRect().x + 4, this.getCheckRect().y + 6 + 2);
            g.drawLine(this.getCheckRect().x + 5, this.getCheckRect().y + 7, this.getCheckRect().x + 5, this.getCheckRect().y + 7 + 2);
            g.drawLine(this.getCheckRect().x + 6, this.getCheckRect().y + 6, this.getCheckRect().x + 6, this.getCheckRect().y + 6 + 2);
            g.drawLine(this.getCheckRect().x + 7, this.getCheckRect().y + 5, this.getCheckRect().x + 7, this.getCheckRect().y + 5 + 2);
            g.drawLine(this.getCheckRect().x + 8, this.getCheckRect().y + 4, this.getCheckRect().x + 8, this.getCheckRect().y + 4 + 2);
            g.drawLine(this.getCheckRect().x + 9, this.getCheckRect().y + 3, this.getCheckRect().x + 9, this.getCheckRect().y + 3 + 2);
        }
        g.setColor(this.m_ViewStyle.GetBorderColor(hot));
        g.draw(this.getCheckRect());
    }

    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32 && this.isEnabled() && !this.m_ReadOnly) {
            this.ToggleChecked();
            this.OnCheckedChanged();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseModifiers = e.getModifiersEx();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.m_MouseModifiers = 0;
        if (this.isEnabled() && !this.m_ReadOnly) {
            this.ToggleChecked();
            this.OnCheckedChanged();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void ToggleChecked() {
        this.m_Checked = !this.m_Checked;
        this.repaint();
    }

    public boolean getChecked() {
        return this.m_Checked;
    }

    public void setChecked(boolean value) {
        if (this.m_Checked != value) {
            this.m_Checked = value;
            this.repaint();
        }
    }

    public boolean getReadOnly() {
        return this.m_ReadOnly;
    }

    public void setReadOnly(boolean value) {
        if (this.m_ReadOnly != value) {
            this.m_ReadOnly = value;
        }
    }

    public int getCheckAreaAlign() {
        return this.m_CheckAreaAlign;
    }

    public void setCheckAreaAlign(int value) {
        if (this.m_CheckAreaAlign != value) {
            this.m_CheckAreaAlign = value;
            this.repaint();
        }
    }

    private Rectangle getCheckRect() {
        switch (this.m_CheckAreaAlign) {
            case 1: {
                return new Rectangle((this.getWidth() - 12) / 2, (this.getHeight() - 12) / 2, 12, 12);
            }
            case 2: {
                return new Rectangle(0, (this.getHeight() - 12) / 2, 12, 12);
            }
            case 3: {
                return new Rectangle(this.getWidth() - 13, (this.getHeight() - 12) / 2, 12, 12);
            }
        }
        return null;
    }

    protected void OnCheckedChanged() {
    }
}

