/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.ViewStyle;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class WButton
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    private ActionListener m_pActionListner = null;
    private boolean m_UseStaticViewStyle = true;
    private ViewStyle m_ViewStyle = null;
    private String m_Text = "";
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;

    public WButton() {
        this.m_ViewStyle = new ViewStyle();
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.setFont(new Font("SansSerif", 0, 12));
    }

    public void paintComponent(Graphics g) {
        Rectangle clientRect = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        boolean hot = this.hasFocus() || clientRect.contains(this.m_MousePos);
        this.DrawButton((Graphics2D)g, hot, this.m_MouseModifiers == 1024);
    }

    private void DrawButton(Graphics2D g, boolean hot, boolean pressed) {
        Rectangle clientRect = new Rectangle(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        g.setColor(this.m_ViewStyle.GetButtonColor(hot, pressed));
        g.fill(clientRect);
        Rectangle txtRect = new Rectangle(1, 1, this.getSize().width - 1, this.getSize().height - 1);
        if (pressed) {
            txtRect = new Rectangle(txtRect.x + 1, txtRect.y + 2, txtRect.width - 1, txtRect.height - 2);
        }
        if (this.isEnabled()) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.GRAY);
        }
        Paint.DrawText(g, this.getFont(), this.getText(), txtRect, 1);
        g.setColor(this.m_ViewStyle.GetBorderColor(hot));
        g.draw(clientRect);
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseModifiers = e.getModifiersEx();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.m_MouseModifiers = 0;
        if (this.isEnabled()) {
            this.OnButtonClicked();
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
            this.DrawButton((Graphics2D)this.getGraphics(), true, true);
            if (e.getKeyCode() != 32 && e.getKeyCode() == 10) {
                this.OnButtonClicked();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
            this.DrawButton((Graphics2D)this.getGraphics(), true, false);
            if (e.getKeyCode() == 32) {
                this.OnButtonClicked();
            }
        }
    }

    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public String getText() {
        return this.m_Text;
    }

    public void setText(String value) {
        if (value != this.m_Text) {
            this.m_Text = value;
            this.repaint();
        }
    }

    public void addClickedListener(ActionListener l) {
        this.m_pActionListner = AWTEventMulticaster.add(this.m_pActionListner, l);
    }

    public void removeClickedListener(ActionListener l) {
        this.m_pActionListner = AWTEventMulticaster.remove(this.m_pActionListner, l);
    }

    private void OnButtonClicked() {
        if (this.m_pActionListner != null) {
            ActionEvent act = new ActionEvent(this, 1001, "");
            this.m_pActionListner.actionPerformed(act);
        }
    }
}

