/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.Hashtable;

public class Paint {
    public static int CalcTextHeight(Graphics2D g, Font font, String text, int width) {
        int retVal = 0;
        Font gFont = g.getFont();
        g.setFont(font);
        if (text.length() > 0) {
            Hashtable<TextAttribute, Float> map = new Hashtable<TextAttribute, Float>();
            map.put(TextAttribute.SIZE, new Float(font.getSize()));
            AttributedString aStr = new AttributedString(text, map);
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(aStr.getIterator(), g.getFontRenderContext());
            while (lineMeasurer.getPosition() < text.length()) {
                TextLayout layout = lineMeasurer.nextLayout(width);
                retVal = (int)((float)retVal + (layout.getAscent() + layout.getDescent() + layout.getLeading()));
            }
        } else {
            retVal = g.getFontMetrics().getHeight();
        }
        g.setFont(gFont);
        return ++retVal;
    }

    public static int CalcTextWidth(Graphics2D g, Font font, String text) {
        int retVal = 0;
        Font gFont = g.getFont();
        g.setFont(font);
        TextLayout layout = new TextLayout(text, font, g.getFontRenderContext());
        retVal = (int)layout.getBounds().getWidth();
        g.setFont(gFont);
        return retVal;
    }

    public static void DrawText(Graphics2D g, Font font, String text, Rectangle rect, int hzAlign) {
        if (text.length() == 0) {
            return;
        }
        Font gFont = g.getFont();
        g.setFont(font);
        int textHeight = Paint.CalcTextHeight(g, font, text, rect.width);
        float drawY = (float)rect.getY();
        drawY += (float)((rect.height - textHeight) / 2);
        Hashtable<TextAttribute, Float> map = new Hashtable<TextAttribute, Float>();
        map.put(TextAttribute.SIZE, new Float(font.getSize()));
        AttributedString aStr = new AttributedString(text, map);
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(aStr.getIterator(), g.getFontRenderContext());
        while (lineMeasurer.getPosition() < text.length()) {
            TextLayout layout = lineMeasurer.nextLayout((int)rect.getWidth());
            drawY += layout.getAscent();
            Rectangle2D tBounds = layout.getBounds();
            switch (hzAlign) {
                case 1: {
                    layout.draw(g, (float)rect.getX() + (float)((double)rect.width - tBounds.getWidth()) / 2.0f, drawY);
                    break;
                }
                case 2: {
                    layout.draw(g, (int)rect.getX(), drawY);
                    break;
                }
                case 3: {
                    layout.draw(g, (float)rect.getX() + (float)((double)rect.width - tBounds.getWidth()), drawY);
                }
            }
            drawY += layout.getDescent() + layout.getLeading();
        }
        g.setFont(gFont);
    }

    public static void DrawTriangle(Graphics2D g, Rectangle rect, int direction) {
        int x = rect.x;
        int y = rect.y;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (direction) {
            case 1: {
                g.fillPolygon(new int[]{x, x + rect.width / 2, x + rect.width}, new int[]{y + rect.height, y, y + rect.height}, 3);
                break;
            }
            case 2: {
                g.fillPolygon(new int[]{x, x + rect.width / 2, x + rect.width}, new int[]{y, y + rect.height, y}, 3);
                break;
            }
            case 3: {
                g.fillPolygon(new int[]{x, x + rect.width, x + rect.width}, new int[]{y + rect.height / 2, y, y + rect.height}, 3);
                break;
            }
            case 4: {
                g.fillPolygon(new int[]{x, x + rect.width, x}, new int[]{y, y + rect.height / 2, y + rect.height}, 3);
            }
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }
}

