/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Control.WGrid;

import LumiSoft.UI.Control.WGrid.WGridTableView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class WGridControl
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private WGridTableView m_pMainView = null;
    protected WGridTableView m_pFocusedView = new WGridTableView(this);
    protected ArrayList m_pActiveViews = null;

    public WGridControl() {
        this.m_pFocusedView.getCloumns().AddColumn("Col 1", 70);
        this.m_pFocusedView.getCloumns().AddColumn("Col 2", 80);
        this.m_pFocusedView.getCloumns().AddColumn("Col 3", 120);
        this.m_pMainView = this.m_pFocusedView;
        this.m_pActiveViews = new ArrayList();
        this.m_pActiveViews.add(this.m_pFocusedView);
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public void paintComponent(Graphics g) {
        if (this.m_pMainView != null) {
            this.m_pMainView.setBounds(new Rectangle(10, 10, this.getBounds().width - 10, this.getBounds().height - 10));
            this.m_pMainView.Paint((Graphics2D)g);
        }
        if (this.m_pFocusedView != null) {
            this.m_pFocusedView.Paint((Graphics2D)g);
        }
    }

    public void keyTyped(KeyEvent e) {
        if (this.m_pFocusedView != null) {
            this.m_pFocusedView.Process_keyTyped(e);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.m_pFocusedView != null) {
            this.m_pFocusedView.Process_keyPressed(e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.m_pFocusedView != null) {
            this.m_pFocusedView.Process_keyReleased(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        WGridTableView view = this.GetMouseInTableView(e.getPoint());
        if (view != null) {
            view.Process_mousePressed(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        WGridTableView view = this.GetMouseInTableView(e.getPoint());
        if (view != null) {
            view.Process_mouseReleased(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        WGridTableView view = this.GetMouseInTableView(e.getPoint());
        if (view != null) {
            view.Process_mouseEntered(e);
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.m_pFocusedView != null) {
            this.m_pFocusedView.Process_mouseWheelMoved(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        WGridTableView view = this.GetMouseInTableView(e.getPoint());
        if (view != null) {
            view.Process_mouseMoved(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        WGridTableView view = this.GetMouseInTableView(e.getPoint());
        if (view != null) {
            view.Process_mouseClicked(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        WGridTableView view = this.GetMouseInTableView(e.getPoint());
        if (view != null) {
            view.Process_mouseDragged(e);
        }
    }

    private WGridTableView GetMouseInTableView(Point pt) {
        int i = this.m_pActiveViews.size() - 1;
        while (i > -1) {
            WGridTableView view = (WGridTableView)this.m_pActiveViews.get(i);
            if (view.getBounds().contains(pt)) {
                return view;
            }
            --i;
        }
        return this.m_pFocusedView;
    }
}

